using System;
using System.Data;


namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>COE User</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/20/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Blood units can be cross-matched for multiple patients and this class gets the details
		///associated with those patients.
		///</summary>

		#endregion

	public class PatientAssignments
	{
		#region Variables

		//private System.Data.DataTable _patientAssignments;
		//private BOL.Patient _assignPatient;

		#endregion

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/20/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6454"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6455"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Returns a data table of patient assignments from their bloodUnitGUID
        /// </summary>
        /// <param name="bloodUnitGuid"></param>
        /// <returns></returns>
		public static System.Data.DataTable GetPatientAssignments(System.Guid bloodUnitGuid)
		{
			return DAL.PatientAssignments.GetPatientsAssignmentDetails(bloodUnitGuid);			
		}
        //


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/18/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="6456"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>DataTable with Assignment details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6457"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// A blood unit can be cross-matched for multiple patients.
		/// This method returns all cross-matched patients and specimens.
		/// </summary>
		/// <param name="bloodUnitGuid">Blood Unit unique identifier</param>
		/// <returns>Data table of patient and specimen unique identifiers</returns>
		public static DataTable GetPatientSpecimenAssignmentDetails(System.Guid bloodUnitGuid)
		{
			return DAL.PatientAssignments.GetPatientSpecimenAssignmentDetails(bloodUnitGuid);
		}

        /// <summary>
        /// A blood unit can be cross-matched for multiple patients.
        /// This method returns all cross-matched patients' details.
        /// </summary>
        /// <param name="bloodUnitGuid"></param>
        /// <returns></returns>
        public static System.Data.DataTable GetPatientsAssignmentDetails(System.Guid bloodUnitGuid)
        {
            return DAL.PatientAssignments.GetPatientsAssignmentDetails(bloodUnitGuid);
        }
	}
}
